import os
import importlib

# TODO - LEVELS NOT IMPLEMENTED
# 00003 - KnockBarOnWall - has issue where green bar is not sitting within the basket
# 00004 - BalanceBeam - needs variable ball size, collision retention, infinite balls
# 00008 - Staircase - change success logic to use phyre2.utils.detect_success_basket

def list_available_tasks():
    """Return a list of all available tasks."""
    tasks = []
    tasks_folder = "Environment/Environments/Phyre/tasks/"
    for file_name in os.listdir(tasks_folder):
        if file_name.endswith(".py") and file_name != "__init__.py":
            tasks.append(file_name[:-3])
    return tasks

def get_task(task_name):
    class_name = "".join([word.capitalize() for word in task_name.split("_")])
    module = importlib.import_module(f"Environment.Environments.Phyre.tasks.{task_name}")
    task = getattr(module, class_name)()
    return task
